import { NoCache, buildCacheHeader } from '.';

describe(buildCacheHeader, () => {
  it('indicates not to cache when calculated maxAge equals 0', () => {
    expect(
      buildCacheHeader({
        staleIfError: 1,
        staleWhileRevalidate: 11,
        totalCacheLife: 10,
      }),
    ).toEqual(NoCache);
  });

  it('indicates not to cache when totalCacheLife explicitly set to 0', () => {
    expect(buildCacheHeader({ totalCacheLife: 0 })).toEqual(NoCache);
  });

  it('uses values provided and calculates proper maxAge', () => {
    const [, maxAge, staleWhileRevalidate, staleIfError] = buildCacheHeader({
      staleIfError: 1,
      staleWhileRevalidate: 1,
      totalCacheLife: 10,
    }).split(', ');

    expect(maxAge).toEqual(`max-age=9`);
    expect(staleWhileRevalidate).toEqual(`stale-while-revalidate=1`);
    expect(staleIfError).toEqual(`stale-if-error=1`);
  });
});
