/**
 * Creates an array of elements split into groups the length of `size`. If `list` can't be split evenly, the final chunk will be the remaining elements.
 *
 * @param {Array} [list] The array of elements to split
 * @param {number} [size] the length of the groups
 */
export function chunk<T>(list: T[], size: number): T[][] {
  const chunked = [];
  for (let idx = 0; idx < list.length; idx += size) {
    chunked.push(list.slice(idx, idx + size));
  }

  return chunked;
}
