import { containsSpecialCharacters } from '.';

describe(containsSpecialCharacters, () => {
  it.each`
    text         | hasSpecialCharacters
    ${'hi'}      | ${false}
    ${'⚡️👹⚡'} | ${true}
    ${'목츄리'}  | ${true}
  `(
    'returns $hasSpecialCharacters for $text',
    ({ hasSpecialCharacters, text }) => {
      expect(containsSpecialCharacters(text)).toEqual(hasSpecialCharacters);
    },
  );
});
