/* eslint-disable @typescript-eslint/explicit-module-boundary-types */
/**
 * Returns the most accurate message possible for an error caught in a
 * try/catch block.
 */
export function errorMessageFromCatch(e: any): string {
  if (e === null) {
    return 'No message (null)';
  }

  if (typeof e === 'undefined') {
    return 'No message (undefined)';
  }

  if (e instanceof Error) {
    return e.toString();
  }

  // Don't use `toString` on objects otherwise it outputs `[object Object]`
  if (typeof e === 'object') {
    return stringifyObject(e);
  }

  // When can this happen? No idea, since almost all types should run through
  // the stringifier
  return e;
}

export function stringifyObject(err: any): string {
  const plainObject: { [key: string]: string } = {};

  Object.getOwnPropertyNames(err).forEach((key) => {
    plainObject[key] = err[key];
  });

  return JSON.stringify(plainObject, null, ',');
}
