import { errorMessageFromCatch, stringifyObject } from '.';

describe(errorMessageFromCatch, () => {
  it('handles a null error', () => {
    expect(errorMessageFromCatch(null)).toEqual('No message (null)');
  });

  it('handles an undefined error', () => {
    expect(errorMessageFromCatch(undefined)).toEqual('No message (undefined)');
  });

  it('handles a string error', () => {
    expect(errorMessageFromCatch('I am an error')).toEqual('I am an error');
  });

  it('handles a number error', () => {
    expect(errorMessageFromCatch(32)).toEqual(32);
  });

  it('returns toString() for an Error', () => {
    const error = new Error('Something sucks');
    expect(errorMessageFromCatch(error)).toEqual('Error: Something sucks');
  });

  it('string-ifies a normal object instead of returning [object Object]', () => {
    const err = {
      toString: () => 'yup, an error',
    };
    expect(errorMessageFromCatch(err)).toEqual(stringifyObject(err));
  });
});

describe(stringifyObject, () => {
  it('works with POJOs', () => {
    const pojo = {
      boop: 'baz',
      foo: 'bar',
    };

    // eslint-disable-next-line jest/no-large-snapshots
    expect(stringifyObject(pojo)).toMatchInlineSnapshot(`
      "{
      ,\\"boop\\": \\"baz\\",
      ,\\"foo\\": \\"bar\\"
      }"
    `);
  });
});
