import { DEFAULT_SERVER_TIMEOUT, Formats, fetchData } from '.';

const URL = 'https://www.twitch.tv/monstercat';

describe('fetchData', () => {
  beforeEach(fetchMock.resetMocks);

  it('passes the right parameters to fetch', () => {
    fetchMock.mockResponseOnce(JSON.stringify('test'));
    const HEADERS = { 'X-a-header': 'do not use X-' };
    const TIMEOUT = 9;
    fetchData(URL, HEADERS, Formats.JSON, TIMEOUT);
    expect(fetch).toHaveBeenCalledWith(URL, {
      headers: HEADERS,
      timeout: TIMEOUT,
    });
  });

  it('uses sane defaults', () => {
    fetchMock.mockResponseOnce(JSON.stringify('test'));
    fetchData(URL);
    expect(fetch).toHaveBeenCalledWith(URL, {
      headers: {},
      timeout: DEFAULT_SERVER_TIMEOUT,
    });
  });

  it('handles an unsuccessful status', async () => {
    const error = new Error('big andy rejects this');
    fetchMock.mockReject(error);
    await expect(fetchData(URL)).rejects.toThrow(error);
  });

  it('handles a successful JSON response', async () => {
    const expectedResult = { user: 'bigAndy' };
    fetchMock.mockResponseOnce(JSON.stringify(expectedResult));
    expect(await fetchData(URL)).toEqual(expectedResult);
  });

  it('handles a successful TEXT response', async () => {
    const expectedResult = 'bigAndy is a popular value to put in tests';
    fetchMock.mockResponseOnce(JSON.stringify(expectedResult));
    expect(await fetchData(URL)).toEqual(expectedResult);
  });
});
