import type { HeaderOrParamValue } from '.';
import { flattenHeaderOrParam } from '.';

interface FlattenHeaderTestCase {
  expected: string | undefined;
  useLast?: boolean;
  value: HeaderOrParamValue;
}

describe(flattenHeaderOrParam, () => {
  it.each`
    value           | useLast      | expected
    ${null}         | ${undefined} | ${undefined}
    ${undefined}    | ${undefined} | ${undefined}
    ${'a'}          | ${undefined} | ${'a'}
    ${['a', 'b']}   | ${undefined} | ${'a'}
    ${['a', 'b']}   | ${true}      | ${'b'}
    ${{ a: 'b' }}   | ${undefined} | ${undefined}
    ${[{ a: 'b' }]} | ${undefined} | ${undefined}
    ${[{ a: 'b' }]} | ${true}      | ${undefined}
  `(
    'returns $expected when given $value (and useLast is $useLast)',
    ({ expected, useLast, value }: FlattenHeaderTestCase) => {
      expect(flattenHeaderOrParam(value, useLast)).toBe(expected);
    },
  );
});
