/**
 * Creates an object composed of keys generated from the results of running
 * each element of collection thru iteratee.
 *
 * @param array collection to group
 * @param function iteratee to transform keys
 */
export function groupBy<T, U extends number | string | symbol>(
  collection: readonly T[],
  iteratee: (item: T) => U,
): Record<U, T[]> {
  const grouped = {} as Record<U, T[] | undefined>;
  for (const item of collection) {
    const key = iteratee(item);
    let group = grouped[key];
    if (!group) {
      grouped[key] = group = [];
    }
    group.push(item);
  }
  return grouped as Record<U, T[]>;
}
