import { groupBy } from '.';

describe(groupBy, () => {
  it('uses iteratee function to transform keys', () => {
    const collection = [
      { bucket: 'apples', id: 1 },
      { bucket: 'oranges', id: 2 },
      { bucket: 'apples', id: 3 },
      { bucket: 'bananas', id: 4 },
      { bucket: 'oranges', id: 5 },
    ];

    const grouped = groupBy(collection, (item) => item.bucket.toUpperCase());

    expect(grouped).toEqual({
      APPLES: [
        { bucket: 'apples', id: 1 },
        { bucket: 'apples', id: 3 },
      ],
      ORANGES: [
        { bucket: 'oranges', id: 2 },
        { bucket: 'oranges', id: 5 },
      ],
      // the order of the keys is important for the return value, so in order
      // for it to reflect to real values, disabling the lint error here.
      // eslint-disable-next-line sort-keys-fix/sort-keys-fix
      BANANAS: [{ bucket: 'bananas', id: 4 }],
    });
  });
});
