import { htmlescape } from '.';

describe('htmlEscapeJsonString', () => {
  it.each`
    input                                | output
    ${''}                                | ${''}
    ${'1'}                               | ${'1'}
    ${JSON.stringify({})}                | ${'{}'}
    ${JSON.stringify({ 1: 2 })}          | ${'{"1":2}'}
    ${JSON.stringify({ 1: '&' })}        | ${'{"1":"\\u0026"}'}
    ${JSON.stringify({ 1: '1 < 2' })}    | ${'{"1":"1 \\u003c 2"}'}
    ${JSON.stringify({ 1: '2 > 1' })}    | ${'{"1":"2 \\u003e 1"}'}
    ${JSON.stringify({ 1: '<script>' })} | ${'{"1":"\\u003cscript\\u003e"}'}
  `('should return $output if input is $input', ({ input, output }) => {
    expect(htmlescape(input)).toBe(output);
  });
});
