/*
 * kebabCase implementation adapted from lodash
 * https://github.com/lodash/lodash/blob/4.17.15/lodash.js#L14301
 */

/** Used to match words composed of alphanumeric characters. */
/* eslint-disable no-control-regex */
const reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;
/* eslint-enable no-control-regex */

function words(src: string): Array<string> {
  return src.match(reAsciiWord) || [];
}

/**
 * Converts `src` to
 * [kebab case](https://en.wikipedia.org/wiki/Letter_case#Special_case_styles).
 *
 * @param {string} src The string to convert.
 * @returns {string} Returns the kebab cased string.
 * @example
 *
 * kebabCase('Foo Bar');
 * // => 'foo-bar'
 *
 * kebabCase('__FOO_BAR__');
 * // => 'foo-bar'
 */
export function kebabCase(src: string): string {
  return words(src.replace("'", ''))
    .map((w) => w.toLowerCase())
    .join('-');
}
