import { kebabCase } from '.';

describe('kebabCase', () => {
  describe('noop cases', () => {
    it('does not die on an empty string', () => {
      expect(kebabCase('')).toEqual('');
    });

    it('single number', () => {
      expect(kebabCase('1')).toEqual('1');
    });

    it('single emoji', () => {
      expect(kebabCase('🙄')).toEqual('🙄');
    });

    it('single letter', () => {
      expect(kebabCase('a')).toEqual('a');
    });
  });

  describe('single word', () => {
    it('removes symbols', () => {
      expect(kebabCase('#')).toEqual('');
    });

    it('works on characters with diacritics', () => {
      expect(kebabCase('ç')).toEqual('ç');
    });
  });

  describe('multi word', () => {
    it('capitalizes a series of single letters', () => {
      expect(kebabCase('a b c d e')).toEqual('a-b-c-d-e');
    });

    it('handles intermingled capital and non-capital letters', () => {
      expect(kebabCase('a B c D e')).toEqual('a-b-c-d-e');
    });

    it('capitalizes a series of lowercase-starting words', () => {
      expect(kebabCase('always be careful doing everything')).toEqual(
        'always-be-careful-doing-everything',
      );
    });

    it('handles intermingled uppercase- and lowercase-starting words', () => {
      expect(kebabCase('always be careful Doing Everything')).toEqual(
        'always-be-careful-doing-everything',
      );
    });

    it('handles diacritics in multiple words', () => {
      expect(kebabCase('ça ñino')).toEqual('ça-ñino');
    });

    it('handles symbols', () => {
      expect(kebabCase('__FOO_BAR__')).toEqual('foo-bar');
    });
  });

  describe('combo', () => {
    it('handles a mix of stuff', () => {
      expect(
        kebabCase(
          "😩 i cannot believe 😩 that i've written 😩 15 tests for this 😩 stupid function 😩",
        ),
      ).toEqual(
        '😩-i-cannot-believe-😩-that-ive-written-😩-15-tests-for-this-😩-stupid-function-😩',
      );
    });
  });
});
