// istanbul ignore next: trivial
/**
 * This is a utility function to wrap checking the type of window so that it can
 * be mocked for tests in environments like jest where window is automatically
 * provided by jsdom.
 *
 * It is preferred to use `typeof window !== 'undefined'` because that enables
 * better dead-code elimination, so this should only be used when testability
 * is more important.
 */
export function isBrowser(): boolean {
  return typeof window !== 'undefined';
}
