import { isBrowser } from '../isBrowser';

// istanbul ignore next: trivial
/**
 * Whether or not the navigator is online.
 *
 * Browsers implement this property differently.
 *
 * In Chrome and Safari, if the browser is not able to connect to a local area network (LAN) or a router, it is offline; all other conditions return true. So while you can assume that the browser is offline when it returns a false value, you cannot assume that a true value necessarily means that the browser can access the internet.
 *
 * https://developer.mozilla.org/en-US/docs/Web/API/NavigatorOnLine/onLine
 */
export function isOffline(): boolean {
  return isBrowser() ? !window.navigator.onLine : false;
}
