/**
 * Tests whether the target is a plain JS object (and not an array, null, etc)
 */
export function isPlainObject(obj: unknown): obj is {} {
  // null is of type 'object'
  if (Array.isArray(obj) || typeof obj !== 'object' || obj === null) {
    return false;
  }

  // Check that the object is not an ES6 class or JS API instance (Array, DOM, etc)
  return (
    obj.constructor === Object &&
    Object.prototype.toString.call(obj) === '[object Object]'
  );
}
