import { isPlainObject } from '.';

interface IsPlainObjectTestCase {
  expected: boolean;
  input: any;
}
describe(isPlainObject, () => {
  class ES6Class {}

  /*  eslint-disable @typescript-eslint/no-array-constructor */
  it.each`
    expected | input
    ${false} | ${[]}
    ${false} | ${new Array()}
    ${false} | ${new Map()}
    ${false} | ${1}
    ${false} | ${'hello'}
    ${false} | ${Symbol('Bar')}
    ${false} | ${new ES6Class()}
    ${false} | ${document.createElement('div')}
    ${false} | ${new Date()}
    ${true}  | ${{}}
    ${true}  | ${{ foo: '1' }}
  `(
    'returns $expected for $input',
    ({ expected, input }: IsPlainObjectTestCase) => {
      expect(isPlainObject(input)).toEqual(expected);
    },
  );
});
