import { KeyCode, KeyValue, legacyKeyboardEventHandler } from '.';

describe(legacyKeyboardEventHandler, () => {
  it('invokes the callback with the expected key when a key is present', () => {
    const callback = jest.fn();
    const handler = legacyKeyboardEventHandler(callback);
    expect(callback).not.toHaveBeenCalled();

    handler({ key: 'foo' } as any);
    expect(callback).toHaveBeenCalledTimes(1);
    expect(callback.mock.calls[0][0].key).toEqual('foo');
  });

  it('sets key to the empty string if it does not match a known keyCode', () => {
    const callback = jest.fn();
    const handler = legacyKeyboardEventHandler(callback);
    expect(callback).not.toHaveBeenCalled();

    handler({ keyCode: 5000 } as any);
    expect(callback).toHaveBeenCalledTimes(1);
    expect(callback.mock.calls[0][0].key).toEqual('');
  });

  it('invokes the callback with a set a key for a known keyCode', () => {
    const callback = jest.fn();
    const handler = legacyKeyboardEventHandler(callback);
    expect(callback).not.toHaveBeenCalled();

    handler({ keyCode: KeyCode.Enter } as any);
    expect(callback).toHaveBeenCalledTimes(1);
    expect(callback.mock.calls[0][0].key).toEqual(KeyValue.Enter);
  });
});
