import { once } from '.';

describe('once', () => {
  it('only calls wrapped function once', () => {
    const fn = jest.fn().mockReturnValue(2);
    const onceFn = once(fn);

    expect(onceFn()).toEqual(2);
    expect(onceFn()).toEqual(2);
    expect(onceFn()).toEqual(2);
    expect(fn).toHaveBeenCalledTimes(1);
  });

  it('passes arguments to wrapped function', () => {
    const fn = jest.fn();
    const onceFn = once(fn);
    onceFn(34);

    expect(fn).toHaveBeenCalledWith(34);
  });
});
