/**
 * Creates an array of elements split into two groups, the first of which
 * contains elements predicate returns truthy for, the second of which contains
 * elements predicate returns falsey for.
 *
 * @param array the source array
 * @param function predicate
 */
export function partition<T>(
  array: ReadonlyArray<T>,
  predicate: (item: T) => boolean,
): [T[], T[]] {
  const passes = [];
  const fails = [];

  for (const item of array) {
    if (predicate(item)) {
      passes.push(item);
    } else {
      fails.push(item);
    }
  }

  return [passes, fails];
}
