/**
 * Creates a new object based on the list of keys passed in.
 * @param obj the source object
 * @param keys the array of target keys to copy into the returned object
 */
export function pick<Out extends Record<string, unknown>, In extends Out>(
  obj: In,
  keys: string[],
): Out {
  return Object.entries(obj).reduce((acc, [key, value]) => {
    if (keys.includes(key)) {
      // TS is dumb about reduce
      (acc as any)[key] = value;
    }

    return acc;
    // generics doesn't appease TS enough
  }, {} as Out);
}
