import {
  isBoolean,
  isNumber,
  isNumberArray,
  isString,
  isStringArray,
} from '../typeguards';

// extension of the sibling typeguard functions

/**
 * Ensures that value is boolean or otherwise returns fallback
 */
export function ensureBoolean(value: unknown, fallback: boolean): boolean {
  return isBoolean(value) ? value : fallback;
}

/**
 * Ensures that value is number or otherwise returns fallback
 */
export function ensureNumber(value: unknown, fallback: number): number {
  return isNumber(value) ? value : fallback;
}

/**
 * Ensures that value is string or otherwise returns fallback
 */
export function ensureString(value: unknown, fallback: string): string {
  return isString(value) ? value : fallback;
}

/**
 * Ensures that value is number array or otherwise returns fallback
 */
export function ensureNumberArray(
  value: unknown,
  fallback: number[],
): number[] {
  return isNumberArray(value) ? value : fallback;
}

/**
 * Ensures that value is string array or otherwise returns fallback
 */
export function ensureStringArray(
  value: unknown,
  fallback: string[],
): string[] {
  return isStringArray(value) ? value : fallback;
}
