/**
 * Used as an exhaustive case for a switch statement when the
 * default case should never be hit.
 *
 * @example
 *
 * enum Item {
 *   First,
 *   second,
 * }
 * function getItemText(item: Item): string {
 *   switch (item) {
 *     case Item.First:
 *       return 'first';
 *     case item.Second:
 *       return 'second';
 *     default:
 *       // Will throw a TypeScript error if the First or Second case is commented out
 *       return exhaustedCase(item, '');
 *   }
 * }
 */
export function exhaustedCase<T>(
  _: never | '%future added value' | '%other', // eslint-disable-line relay/no-future-added-value
  fallback: T,
): T {
  return fallback;
}
