const MINUTE = 60;
const HOUR = 60 * MINUTE;
const DAY = 24 * HOUR;

/**
 * Converts a number of seconds to a human readable string format. e.g.:
 * - 59 seconds: 0:59
 * - 61 seconds: 1:01
 * - 90,000 seconds: 1:01:00
 *
 * @param length The length of a video in seconds.
 */
export function formatVideoLength(length: number): string {
  let remainingTime = length;
  const days = Math.floor(remainingTime / DAY);
  remainingTime -= days * DAY;
  const hours = Math.floor(remainingTime / HOUR);
  remainingTime -= hours * HOUR;
  const minutes = Math.floor(remainingTime / MINUTE);

  const timePieces = [days, hours, minutes, remainingTime - minutes * MINUTE];

  while (timePieces[0] === 0 && timePieces.length > 2) {
    timePieces.shift();
  }

  return timePieces
    .map((val, idx) => (idx === 0 || val > 9 ? val : `0${val}`))
    .join(':');
}
