import { formatVideoLength } from '.';

describe('formatVideoLength', () => {
  const testCases = [
    {
      formattedLength: '0:00',
      length: 0,
      title: 'formats zero',
    },
    {
      formattedLength: '0:41',
      length: 41,
      title: 'adds zero minutes to seconds-long videos',
    },
    {
      formattedLength: '4:08:06',
      length: 14886,
      title: 'zero pads non leading single digit numbers',
    },
    {
      formattedLength: '6:34:00',
      length: 23640,
      title: 'does not strip internal zeros',
    },
    {
      formattedLength: '10:13:10',
      length: 36790,
      title: 'does not zero pad two digit numbers',
    },
    {
      formattedLength: '1:15:57:03',
      length: 143823,
      title: 'handles days',
    },
  ];

  testCases.forEach(({ formattedLength, length, title }) => {
    it(title, () => {
      expect(formatVideoLength(length)).toEqual(formattedLength);
    });
  });
});
