/**
 * Gets the top two levels of domain for potential Twitch domains that tachyon
 * apps might run on. This allows the app to determine where it is running.
 *
 * @param hostname The hostname you want to get the second-level domain and TLD for.
 */
export function getCurrentTwitchDomain(
  hostname: string | undefined,
): string | undefined {
  if (!hostname) {
    return;
  }

  const results =
    hostname.match(/\.twitch\.(?:tv|a2z\.com)/) ||
    hostname.match(/\.xarth\.tv/);
  if (results) {
    return results[0].slice(1);
  }
}
