import { getCurrentTwitchDomain } from '.';

describe(getCurrentTwitchDomain, () => {
  it('returns nothing when the domain is undefined', () => {
    expect(getCurrentTwitchDomain(undefined)).toBeUndefined();
  });

  it('returns nothing when the domain does not match', () => {
    expect(getCurrentTwitchDomain('phish.us')).toBeUndefined();
  });

  it('matches xarth.tv domains', () => {
    expect(getCurrentTwitchDomain('seaside.mweb-staging.xarth.tv')).toEqual(
      'xarth.tv',
    );
  });

  it('matches twitch.a2z.tv domains', () => {
    expect(
      getCurrentTwitchDomain('fix7y1uvk4b1ahet92bx.tv.twitch.a2z.com/'),
    ).toEqual('twitch.a2z.com');
  });

  it('matches twitch.tv domains', () => {
    expect(getCurrentTwitchDomain('m.twitch.tv')).toEqual('twitch.tv');
  });

  it('does not match near-xarth.tv domains', () => {
    expect(
      getCurrentTwitchDomain('seaside.mweb-staging.notxarth.tv'),
    ).toBeUndefined();
  });

  it('does not match near-twitch.a2z.tv domains', () => {
    expect(
      getCurrentTwitchDomain('fix7y1uvk4b1ahet92bx.tv.nottwitch.a2z.tv'),
    ).toBeUndefined();
  });

  it('does not match near-twitch.tv domains', () => {
    expect(getCurrentTwitchDomain('m.nottwitch.tv')).toBeUndefined();
  });
});
