// Various opt types for overload signatures
import { containsSpecialCharacters } from 'tachyon-utils-stdlib';

type GetFormattedUserDisplayNameOpts = {
  displayName: string;
  login: string;
};

/**
 * Handles formatting a user's display name as represented in a UI. If
 * international characters are detected, it returns the international display
 * name format. If only login or displayName are non-null, then that value is
 * returned. If both are null, then null is returned. Overloaded such that
 * passing at least one value as a known string will return a string and passing
 * both as known nulls will return null. If both a nullable but uncertain,
 * returns string | null.
 */
export function getFormattedUserDisplayName(
  opts: GetFormattedUserDisplayNameOpts,
): string;
export function getFormattedUserDisplayName(
  opts: GetFormattedUserDisplayNameOpts | null,
): null;
export function getFormattedUserDisplayName(
  opts: GetFormattedUserDisplayNameOpts | null,
): string | null {
  if (!opts) {
    return null;
  }

  const { displayName, login } = opts;
  if (!displayName) {
    return login;
  }

  if (!login) {
    return displayName;
  }

  if (containsSpecialCharacters(displayName)) {
    return `${displayName} (${login})`;
  }

  return displayName;
}
