import { getFormattedUserDisplayName } from '.';

describe(getFormattedUserDisplayName, () => {
  it('returns null when opts is null', () => {
    // type test to ensure nulls return only null
    const output: null = getFormattedUserDisplayName(null);
    expect(output).toBeNull();
  });

  it('returns an international format display name if international characters are in the display name', () => {
    const displayName = '목츄리';
    const login = 'mokchuri';
    // type test to ensure a non-null args object always returns a string
    const output: string = getFormattedUserDisplayName({ displayName, login });
    expect(output).toEqual(`${displayName} (${login})`);
  });

  // keeps TS from narrowing union types
  const makeTypescriptUnsure = null;
  it('returns just the display name of the user if no international characters are detected', () => {
    // type test to ensure a nullable object returns string or null
    const output: string | null = getFormattedUserDisplayName(
      makeTypescriptUnsure
        ? null
        : { displayName: 'Therealderekt', login: 'therealderekt' },
    );
    expect(output).toEqual('Therealderekt');
  });
});
