import { lorem } from 'faker';
import { getGameDisplayName } from '.';

describe(getGameDisplayName, () => {
  const randomDisplayName = lorem.word();
  const fallbackString = lorem.word();
  it.each`
    game                                  | fallback          | expected
    ${null}                               | ${null}           | ${''}
    ${{ displayName: randomDisplayName }} | ${null}           | ${randomDisplayName}
    ${{ name: randomDisplayName }}        | ${null}           | ${randomDisplayName}
    ${null}                               | ${fallbackString} | ${fallbackString}
  `(
    'returns $expected when game is $game and fallback is $fallback',
    ({ expected, fallback, game }: any) => {
      expect(getGameDisplayName(game, fallback)).toEqual(expected);
    },
  );
});
