import {
  GLOBAL_COOKIE_NAMES,
  getAndExtendCookieValue,
  setCookieValue,
} from '../../cookies';
import { DEFAULT_ID_LENGTH, uniqueIDGenerator } from '../uniqueIDGenerator';
/**
 * A device id prefix to indicate when a device id is generated by the app
 * instead of the receiving one from the CDN.
 */
export const TACHYON_DEVICE_ID_PREFIX = 'tach';
const TACHYON_DEVICE_ID_POSTFIX_LENGTH =
  DEFAULT_ID_LENGTH - TACHYON_DEVICE_ID_PREFIX.length;

export function createTachyonDeviceID(): string {
  return `${TACHYON_DEVICE_ID_PREFIX}${uniqueIDGenerator(
    TACHYON_DEVICE_ID_POSTFIX_LENGTH,
  )}`;
}

/**
 * Gets the common twitch device ID from cookies.
 *
 * @param req a server request object
 */
export function getDeviceIDInBrowser(): string | undefined {
  return getAndExtendCookieValue({
    name: GLOBAL_COOKIE_NAMES.DEVICE_ID_COOKIE_NAME,
  });
}

// currently not exported from the package in preference of server-side generation
/**
 * Tries to get a device ID value from cookies, and if not found it
 * generates a tachyon device ID and persists it.
 *
 * @return the found or generated device id
 */
export function getOrCreateDeviceIDInBrowser(): string {
  let deviceID = getAndExtendCookieValue({
    name: GLOBAL_COOKIE_NAMES.DEVICE_ID_COOKIE_NAME,
  });
  if (!deviceID) {
    deviceID = createTachyonDeviceID();
    setCookieValue({
      name: GLOBAL_COOKIE_NAMES.DEVICE_ID_COOKIE_NAME,
      value: deviceID,
    });
  }

  return deviceID;
}
