import { uniqueIDGenerator } from '../uniqueIDGenerator';

// More information about session IDs can be found at the Tracking Users doc page:
// https://git.xarth.tv/pages/emerging-platforms/tachyon/d/apps/tomorrow/processes/tracking-users/

/**
 * The key to use to story the session ID in the session store.
 */
export const SESSION_ID_KEY = 'twitchSessionID';

/**
 * Tries to get a session ID value from sessionStorage, and if not found it
 * generates a session ID and persists it. If sessionStorage is unavailable
 * (such as in private browsing contexts), it will return empty string.
 *
 * @return the found or generated device id, or empty string
 */
export function getOrCreateSessionID(): string {
  let sessionID = '';
  if (typeof window !== 'undefined' && window.sessionStorage) {
    sessionID = window.sessionStorage.getItem(SESSION_ID_KEY) || '';
    if (!sessionID) {
      sessionID = uniqueIDGenerator();
      try {
        window.sessionStorage.setItem(SESSION_ID_KEY, sessionID);
      } catch {
        sessionID = '';
      }
    }
  }

  return sessionID;
}
