import { uniqueIDGenerator } from '../uniqueIDGenerator';
import { SESSION_ID_KEY, getOrCreateSessionID } from '.';

describe(getOrCreateSessionID, () => {
  afterEach(() => {
    sessionStorage.clear();
  });

  it('generates a value when none is present and stores it', () => {
    expect(sessionStorage.getItem(SESSION_ID_KEY)).toBeNull();
    const id = getOrCreateSessionID();
    expect(sessionStorage.getItem(SESSION_ID_KEY)).toEqual(id);
  });

  it('retrieves a value that is previously stored and does not overwrite', () => {
    const id = uniqueIDGenerator();
    sessionStorage.setItem(SESSION_ID_KEY, id);
    expect(getOrCreateSessionID()).toEqual(id);
    expect(sessionStorage.getItem(SESSION_ID_KEY)).toEqual(id);
  });
});
