const alphanums =
  'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';

export const DEFAULT_ID_LENGTH = 32;

/**
 * Function that generates alphanumeric UIDs.
 *
 * @param length length of desired UID, defaults to 32
 * @return alphanumeric UID
 */
export function uniqueIDGenerator(length: number = DEFAULT_ID_LENGTH): string {
  return Array(length)
    .fill(undefined)
    .map(() => alphanums.charAt(Math.floor(Math.random() * alphanums.length)))
    .join('');
}
