import { datatype } from 'faker';
import { uniqueIDGenerator } from '.';

describe(uniqueIDGenerator, () => {
  it('generates a default string', () => {
    const id = uniqueIDGenerator();
    expect(typeof id).toBe('string');
    expect(id).toHaveLength(32);
  });

  it('generates unique ids', () => {
    expect(uniqueIDGenerator()).not.toBe(uniqueIDGenerator());
  });

  it('generates ids of specified length', () => {
    const length = datatype.number({ max: 50, min: 1 });
    expect(uniqueIDGenerator(length)).toHaveLength(length);
  });
});
