# Tachyon Discovery

Package of components and utilities maintained by the Discovery team:

- Mobile Web Search UI Components
- Impression tracking
- Search and Recommendation Tracking / Playback Event Attribution

## Discovery Tracking

This package includes tracking implementations, including an API for playback
event attribution, for the following specifications:

- [Search Tracking](https://docs.google.com/document/d/1AiBHGuIMTr6HXxFIZ8TpZdi4SnHy89HC7vOxTWBdE4I)
  Components
- [Recs 100 Tracking](https://docs.google.com/document/d/1szmiZByK7aXUF3f3ZPN3o6MNUV3FHc6vR3ohHyvW95I)
- [Unified Impressions Tracking](https://docs.google.com/document/d/1Dkhh7CZCYL5eBGzvUaBdKn-VuD23psBNkkdLkMlGXpo/edit#heading=h.k415yufbs02z)

## DiscoveryTrackingRoot

Add `DiscoverTrackingRoot` to your applications root:

```tsx
import type { FC } from 'react';
import { DiscoveryTrackingRoot } from 'tachyon-discovery';

const App: FC = () => {
  return <DiscoveryTrackingRoot {...}>{/* ... */}</DiscoveryTrackingRoot>;
};
```

### useDiscoveryTracking

Use `useDiscoveryTracking` to access the Tracking API.

```tsx
import type { FC } from 'react';
import { useDiscoveryTracking } from 'tachyon-discovery';

const RecommendationItem: FC = () => {
  const { useRecommendationItemClick } = useDiscoveryTracking();
  return (
    <div
      onClick={() => {
        useRecommendationItemClick({
          /*... */
        });
      }}
    />
  );
};
```

### Player Tracking Discovery Feature Attribution

Calling `getAndResetPlayerTracking` will return tracking fields for the
recommendation item or search result having caused a video play and will
immediately reset the context's state.

```tsx
import type { FC } from 'react';
import { useDiscoveryTracking } from 'tachyon-discovery';

const VideoPlayerAbstraction: FC = ({}) => {
  const { trackEvent } = useSomeTrackingLibrary();
  const { getAndResetPlayerTracking } = useDiscoveryTracking();

  function onPlayerEvent(event: string, properties: {}): void {
    trackEvent({
      event,
      ...properties,
      ...getAndResetPlayerTracking(),
    });
  }

  return <VideoPlayer onEvent={onPlayerEvent} />;
};
```
