import { useContext } from 'react';
import type { DiscoveryTrackingContext } from '../DiscoveryTrackingRoot';
import { discoveryTrackingContext } from '../DiscoveryTrackingRoot';

/**
 * Consumers should always use `getAndResetPlayerTracking` rather than the
 * read-only version.
 */
export type DiscoveryTrackingProps = Omit<
  DiscoveryTrackingContext,
  'getPlayerTracking'
>;

export function useDiscoveryTracking(): DiscoveryTrackingProps {
  return useContext(discoveryTrackingContext);
}
