import type { ComponentType, FC } from 'react';
import { getComponentName } from 'tachyon-utils-react';
import type { DiscoveryTrackingProps } from '../useDiscoveryTracking';
import { useDiscoveryTracking } from '../useDiscoveryTracking';

export function withDiscoveryTracking<P extends DiscoveryTrackingProps>(
  Comp: ComponentType<P>,
): ComponentType<Omit<P, keyof DiscoveryTrackingProps>> {
  const WithDiscoveryTrackingComponent: FC<
    Omit<P, keyof DiscoveryTrackingProps>
  > = (props) => {
    const trackingProps = useDiscoveryTracking();
    const mergedProps = {
      ...props,
      ...trackingProps,
    } as P;

    return <Comp {...mergedProps} />;
  };

  WithDiscoveryTrackingComponent.displayName = `WithDiscoveryTracking(${getComponentName(
    Comp,
  )})`;

  return WithDiscoveryTrackingComponent;
}
