import { noopDiscoveryTrackingContext } from './components/tracking/DiscoveryTrackingRoot';
import type { DiscoveryTrackingProps } from './components/tracking/useDiscoveryTracking';
import type { RecommendationTrackingParams } from './utils/tracking/tracking-types';
import { ContentType, ItemPage } from './utils/tracking/tracking-types';

export function mockDiscoveryTrackingProps(): DiscoveryTrackingProps {
  return noopDiscoveryTrackingContext;
}

export function mockRecommendationTrackingParams(): RecommendationTrackingParams {
  return {
    contentType: ContentType.LiveStream,
    itemID: 'item-id',
    itemPage: ItemPage.Discover,
    itemPosition: 1,
    itemTrackingID: 'some-id',
    modelTrackingID: 'model-id',
    reasonTarget: null,
    reasonTargetType: null,
    reasonType: 'personalized',
    rowName: 'TopGamesForYou',
    rowPosition: 0,
    section: 'For You',
  };
}
