import { convertToUnsafeID } from 'tachyon-relay';
import { uniqueIDGenerator } from 'tachyon-utils-twitch';
import type {
  ChannelPageTrackingParams,
  SpadeChannelPageBaseEvent,
} from '../tracking-types';
import { ChannelItemPage } from '../tracking-types';

// istanbul ignore next: trivial
export function channelPageParamsToBaseEvent({
  category,
  channelID,
  component,
  contentType,
  itemPosition,
  itemSubsection,
  itemTrackingID,
  login,
  modelTrackingID,
  section,
}: ChannelPageTrackingParams): SpadeChannelPageBaseEvent {
  return {
    category,
    channel_id: convertToUnsafeID(channelID),
    component,
    content_type: contentType,
    item_page: ChannelItemPage.ChannelPage,
    item_position: itemPosition,
    item_subsection: itemSubsection,
    item_tracking_id: itemTrackingID ?? uniqueIDGenerator(16),
    login,
    model_tracking_id: modelTrackingID,
    section,
  };
}
