import { convertToUnsafeID } from 'tachyon-relay';
import { uniqueIDGenerator } from 'tachyon-utils-twitch';
import type {
  RecommendationTrackingParams,
  SpadeRecommendationBaseEvent,
} from '../tracking-types';
import { ItemPage } from '../tracking-types';

export function recommendationParamsToBaseEvent({
  contentType,
  itemID,
  itemPage,
  itemPosition,
  itemTrackingID,
  modelTrackingID,
  reasonTarget,
  reasonTargetType,
  reasonType,
  rowName,
  rowPosition,
}: RecommendationTrackingParams): SpadeRecommendationBaseEvent {
  return {
    content_type: contentType,
    item_id: convertToUnsafeID(itemID),
    item_page: itemPage,
    item_position: itemPosition,
    item_tracking_id: itemTrackingID || uniqueIDGenerator(16),
    model_tracking_id: modelTrackingID,
    reason_target: reasonTarget,
    reason_target_type: reasonTargetType,
    reason_type: reasonType,
    row_name: rowName,
    row_position: rowPosition,
    section: ItemPage.Discover,
  };
}
