import type { RecommendationEventType } from './recommendation';

export enum ChannelContentType {
  Category = 'category',
  Clip = 'clip',
  LiveStream = 'live',
  Video = 'vod',
}

export enum ChannelItemPage {
  ChannelPage = 'channel_page',
}

export enum ChannelSection {
  About = 'about',
  Clips = 'clips',
  Home = 'home',
  Schedule = 'schedule',
  Videos = 'videos',
}

export enum ChannelSubsection {
  FeaturedStreamer = 'featured_streamers',
  RecentBroadcasts = 'recent_broadcasts',
  RecentCategories = 'recent_categories',
}

export type ChannelPageTrackingParams = {
  category: string | null;
  channelID: string;
  component?: string | undefined;
  contentType: ChannelContentType;
  itemPosition: number;
  itemSubsection: ChannelSubsection;
  itemTrackingID: string | null;
  login: string;
  modelTrackingID: string | null;
  section: ChannelSection;
};

export type SpadeChannelPageBaseEvent = {
  category: string | null;
  channel_id: string;
  component?: string | undefined;
  content_type: ChannelContentType;
  item_page: ChannelItemPage;
  item_position: number;
  item_subsection: ChannelSubsection;
  item_tracking_id: string;
  login: string;
  model_tracking_id: string | null;
  section: string;
};

export type SpadeChannelPageItemDisplayEvent = SpadeChannelPageBaseEvent & {
  event: RecommendationEventType.ItemDisplay;
};

export type SpadeChannelPageItemClickEvent = SpadeChannelPageBaseEvent & {
  event: RecommendationEventType.ItemClick;
};

export type SpadeChannelPageEvent =
  | SpadeChannelPageItemClickEvent
  | SpadeChannelPageItemDisplayEvent;
