export enum RecommendationEventType {
  ItemClick = 'item_click',
  ItemDisplay = 'item_display',
}

export enum ContentType {
  Clip = 'clip',
  Game = 'game',
  LiveStream = 'live',
  Video = 'vod',
}

export enum ItemPage {
  Discover = 'discover',
}

export interface RecommendationTrackingParams {
  contentType: ContentType;
  itemID: string;
  itemPage: ItemPage;
  itemPosition: number;
  itemTrackingID: string | null;
  modelTrackingID: string | null;
  reasonTarget: string | null;
  reasonTargetType: string | null;
  reasonType: string;
  rowName: string | null;
  rowPosition: number;
  section: string;
}

export interface SpadeRecommendationBaseEvent {
  content_type: ContentType;
  item_id: string;
  item_page: string;
  item_position: number;
  item_tracking_id: string;
  model_tracking_id: string | null;
  reason_target: string | null;
  reason_target_type: string | null;
  reason_type: string;
  row_name: string | null;
  row_position: number;
  section: string;
}

export type SpadeRecommendationItemDisplayEvent =
  SpadeRecommendationBaseEvent & {
    event: RecommendationEventType.ItemDisplay;
  };

export type SpadeRecommendationItemClickEvent = SpadeRecommendationBaseEvent & {
  event: RecommendationEventType.ItemClick;
};

export type SpadeRecommendationEvent =
  | SpadeRecommendationItemClickEvent
  | SpadeRecommendationItemDisplayEvent;
