export enum SearchCategory {
  Games = 'games',
  // this shouldn't be search category, but leaving it here for now until we can do
  // a more thorough search cleanup and move this to the `SubSection` enum
  RelatedChannels = 'braavos_channels',
  Streams = 'streams',
  Users = 'users',
  Videos = 'vods',
}

export enum SearchEventButtonType {
  Back = 'back',
  More = 'more',
}

export enum SearchQueryType {
  History = 'history',
  Suggestion = 'suggestion',
  UserTyped = 'user_typed',
}

export enum SubSection {
  Categories = 'categories',
  Channels = 'channels',
  RelatedChannels = 'braavos_channels',
  Videos = 'videos',
}

export enum SearchSuggestionType {
  Category = 'category',
  Channel = 'channel',
  History = 'history',
  Live = 'live',
  Text = 'text',
}

export enum SearchEventType {
  SearchInputClear = 'search_input_clear',
  SearchInputFocus = 'search_input_focus',
  SearchQueryResult = 'search_query_result',
  SearchQuerySubmit = 'search_query_submit',
  SearchResultClick = 'search_result_click',
  SearchResultImpression = 'search_result_impression',
  SearchSuggestionClick = 'search_suggestion_click',
  SearchSuggestionDisplay = 'search_suggestion_display',
  SearchSuggestionRequest = 'search_suggestion_request',
  SearchUIClick = 'search_ui_click',
}

interface SearchBaseEvent {
  search_session_id: string | undefined;
}

export type SpadeSearchQuerySubmitEvent = SearchBaseEvent & {
  event: SearchEventType.SearchQuerySubmit;
  query: string;
  search_query_id: string | undefined;
  suggestion_position: number | null;
  suggestion_tracking_id: string | null;
};

export type SpadeSearchQueryResultEvent = SearchBaseEvent & {
  channel_results: number;
  event: SearchEventType.SearchQueryResult;
  games_results: number;
  live_results: number;
  query: string;
  search_query_id: string | undefined;
  status: string;
  vod_results: number;
};

export type SpadeSearchResultClickEvent = SearchBaseEvent & {
  content_id: string | null;
  content_type: string;
  event: SearchEventType.SearchResultClick;
  game: string | null;
  is_live: boolean;
  item_position: number;
  query: string;
  search_query_id: string | undefined;
  show_all: boolean;
  show_more: boolean;
  srp_item_tracking_id: string | null;
  sub_section: string | null;
  sub_section_position: number;
  vod_id: string | null;
};

export type SpadeSearchResultImpressionEvent = SearchBaseEvent & {
  content_id: string | null;
  event: SearchEventType.SearchResultImpression;
  is_live: boolean;
  item_id: string | null;
  item_position: number;
  query: string;
  search_query_id: string | undefined;
  srp_item_tracking_id: string | null;
  sub_section: string | null;
  sub_section_position: number;
};

export type SpadeSearchUIClickEvent = SearchBaseEvent & {
  button_type: string;
  event: SearchEventType.SearchUIClick;
  query: string;
  search_query_id: string | undefined;
  sub_section: string | null;
};

export type SpadeSearchInputFocusEvent = SearchBaseEvent & {
  event: SearchEventType.SearchInputFocus;
};

export type SpadeSearchInputClearEvent = SearchBaseEvent & {
  event: SearchEventType.SearchInputClear;
  query: string;
  search_query_id: string | undefined;
};

export type SpadeSearchSuggestionRequestEvent = SearchBaseEvent & {
  event: SearchEventType.SearchSuggestionRequest;
  query: string;
  request_id: string;
};

export type SpadeSearchSuggestionDisplayEvent = SearchBaseEvent & {
  event: SearchEventType.SearchSuggestionDisplay;
  item_position: number;
  model_tracking_id: string | null;
  request_id: string;
  response_id: string | null;
  suggestion_text: string;
  suggestion_tracking_id: string;
  suggestion_type: string;
};

export type SpadeSearchSuggestionClickEvent = SearchBaseEvent & {
  clicked_item_id: string;
  event: SearchEventType.SearchSuggestionClick;
  item_position: number;
  model_tracking_id: string | null;
  request_id: string;
  response_id: string | null;
  suggestion_text: string;
  suggestion_tracking_id: string;
  suggestion_type: string;
};

export type SpadeSearchEvent =
  | SpadeSearchInputClearEvent
  | SpadeSearchInputFocusEvent
  | SpadeSearchQueryResultEvent
  | SpadeSearchQuerySubmitEvent
  | SpadeSearchResultClickEvent
  | SpadeSearchResultImpressionEvent
  | SpadeSearchSuggestionClickEvent
  | SpadeSearchSuggestionDisplayEvent
  | SpadeSearchSuggestionRequestEvent
  | SpadeSearchUIClickEvent;

export interface SearchQuerySubmitParams {
  query: string;
  suggestionPosition?: number;
  suggestionTrackingID?: string;
  type: SearchQueryType;
}

export interface SearchClickUIParams {
  buttonType: SearchEventButtonType;
  query: string;
  subSection?: SearchCategory;
}

export interface SearchResultImpressionParams {
  contentID?: string;
  gameID?: string;
  isLive?: boolean;
  itemIndex: number;
  itemRow: number;
  query: string;
  srpItemTrackingID?: string;
  subSection: SearchCategory;
  subSectionPosition?: number;
}

export interface SearchClickResultParams {
  contentID?: string;
  contentType: SearchCategory;
  gameID?: string;
  isLive?: boolean;
  itemIndex: number;
  itemRow: number;
  query: string;
  showAll?: boolean;
  showMore?: boolean;
  srpItemTrackingID?: string;
  subSection: SearchCategory;
  vodID?: string;
}

export interface SearchInputClearParams {
  query: string;
}

export interface SearchSuggestionRequestParams {
  query: string;
  requestID: string;
}

export interface SearchSuggestionDisplayParams {
  itemPosition: number;
  modelTrackingID?: string;
  requestID: string;
  responseID?: string;
  suggestionText: string;
  suggestionTrackingID: string;
  suggestionType: SearchSuggestionType;
}

export interface SearchSuggestionsClickParams
  extends SearchSuggestionDisplayParams {
  clickedItemID: string;
}
