import { convertToUnsafeID } from 'tachyon-relay';
import { uniqueIDGenerator } from 'tachyon-utils-twitch';
import type {
  ContentType,
  RecommendationTrackingParams,
} from '../tracking-types';
import { ItemPage } from '../tracking-types';

export interface WithRecommendationTrackingCard {
  readonly id: string;
  readonly trackingID: string;
}

export interface WithRecommendationTrackingParams {
  readonly reasonTarget: string | null;
  readonly reasonTargetType: string | null;
  readonly reasonType: string;
  readonly rowName: string;
}

export type WithRecommendationTracking<
  T extends WithRecommendationTrackingCard,
> = T & {
  tracking: RecommendationTrackingParams;
};

interface WithRecommendationTrackingsArgs<
  T extends WithRecommendationTrackingCard,
> {
  card: T;
  cardIdx: number;
  contentType: ContentType;
  shelfIdx: number;
  tracking: WithRecommendationTrackingParams;
}

// TODO: reconcile this with API provided by DiscoveryTrackingRoots
export function withRecommendationTracking<
  T extends WithRecommendationTrackingCard,
>({
  card,
  cardIdx,
  contentType,
  shelfIdx,
  tracking,
}: WithRecommendationTrackingsArgs<T>): WithRecommendationTracking<T> {
  return {
    ...card,
    tracking: {
      contentType,
      itemID: convertToUnsafeID(card.id),
      itemPage: ItemPage.Discover,
      itemPosition: cardIdx,
      itemTrackingID: card.trackingID || uniqueIDGenerator(16),
      modelTrackingID: card.trackingID,
      reasonTarget: tracking.reasonTarget,
      reasonTargetType: tracking.reasonTargetType,
      reasonType: tracking.reasonType,
      rowName: tracking.rowName,
      rowPosition: shelfIdx,
      section: ItemPage.Discover,
    },
  };
}
