import { lorem } from 'faker';
import { convertToUnsafeID } from 'tachyon-relay';
import { randomId } from 'tachyon-test-utils';
import { uniqueIDGenerator } from 'tachyon-utils-twitch';
import { ContentType, ItemPage } from '../tracking-types';
import type {
  WithRecommendationTrackingCard,
  WithRecommendationTrackingParams,
} from '.';
import { withRecommendationTracking } from '.';

describe(withRecommendationTracking, () => {
  it('adds RecommendationTracking fields', () => {
    const card: WithRecommendationTrackingCard = {
      id: randomId(),
      trackingID: randomId(),
    };

    const tracking: WithRecommendationTrackingParams = {
      reasonTarget: lorem.word(),
      reasonTargetType: lorem.word(),
      reasonType: lorem.word(),
      rowName: lorem.word(),
    };

    expect(
      withRecommendationTracking({
        card,
        cardIdx: 0,
        contentType: ContentType.LiveStream,
        shelfIdx: 1,
        tracking,
      }),
    ).toEqual({
      ...card,
      tracking: {
        contentType: ContentType.LiveStream,
        itemID: convertToUnsafeID(card.id),
        itemPage: ItemPage.Discover,
        itemPosition: 0,
        itemTrackingID: card.trackingID || uniqueIDGenerator(16),
        modelTrackingID: card.trackingID,
        reasonTarget: tracking.reasonTarget,
        reasonTargetType: tracking.reasonTargetType,
        reasonType: tracking.reasonType,
        rowName: tracking.rowName,
        rowPosition: 1,
        section: ItemPage.Discover,
      },
    });
  });
});
