import type { FC } from 'react';
import { htmlescape } from 'tachyon-utils-stdlib';

type JSONLDProps = {
  data: Record<string, unknown> | string;
};

export const JSONLD: FC<JSONLDProps> = ({ data }: JSONLDProps) => {
  let json;
  try {
    json = typeof data === 'string' ? data : JSON.stringify(data);
  } catch (e) {
    return null;
  }
  const html = htmlescape(json);

  return (
    <script
      // This component has been audited by VX-PROD for safe usage.
      // XSS risk is mitigated by htmlescape
      dangerouslySetInnerHTML={{ __html: html }}
      type="application/ld+json"
    />
  );
};

JSONLD.displayName = 'JSONLD';
