import { createMountWrapperFactory } from 'tachyon-test-utils';
import { JSONLD } from '.';

describe('JSONLD', () => {
  const setup = createMountWrapperFactory(JSONLD, () => ({ data: '' }));

  it.each`
    input                                | output
    ${''}                                | ${''}
    ${'1'}                               | ${'1'}
    ${JSON.stringify({})}                | ${'{}'}
    ${JSON.stringify({ 1: 2 })}          | ${'{"1":2}'}
    ${JSON.stringify({ 1: '&' })}        | ${'{"1":"\\u0026"}'}
    ${JSON.stringify({ 1: '1 < 2' })}    | ${'{"1":"1 \\u003c 2"}'}
    ${JSON.stringify({ 1: '2 > 1' })}    | ${'{"1":"2 \\u003e 1"}'}
    ${JSON.stringify({ 1: '<script>' })} | ${'{"1":"\\u003cscript\\u003e"}'}
  `('should return $output if input is $input', ({ input, output }) => {
    const { wrapper } = setup({ data: input });
    expect(wrapper.html()).toEqual(
      `<script type="application/ld+json">${output}</script>`,
    );
  });

  it('renders null when json cannot be stringified', () => {
    const huge = BigInt(9007199254740991);
    const { wrapper } = setup({ data: { 1: huge } });
    expect(wrapper.html()).toBeNull();
  });
});
