import type { FC } from 'react';
import { createElement } from 'react';

type MetatagsProps = {
  metatags: ReadonlyArray<{
    readonly attributes: ReadonlyArray<{
      readonly key: string;
      readonly value: string;
    }>;
    readonly name: string;
  }>;
};

export const Metatags: FC<MetatagsProps> = (props: MetatagsProps) => {
  const metatags = props.metatags.map((metatag) => {
    const attributes = metatag.attributes.reduce<{ [name: string]: string }>(
      (acc, { key, value }) => ((acc[key] = value), acc),
      {},
    );

    const k = metatag.attributes.reduce<string>(
      (acc, { key, value }) => ((acc += `${key}${value}`), acc),
      metatag.name,
    );

    return createElement(metatag.name, { ...attributes, key: k });
  });

  return <>{metatags}</>;
};

Metatags.displayName = 'Metatags';
