import { createMountWrapperFactory } from 'tachyon-test-utils';
import { Metatags } from '.';

describe('createMetatagElements', () => {
  const setup = createMountWrapperFactory(Metatags, () => ({ metatags: [] }));

  it('returns the metatags', () => {
    const metatags = [
      {
        attributes: [
          { key: 'a', value: 'b' },
          { key: 'c', value: 'd' },
        ],
        name: 'meta',
      },
      {
        attributes: [
          { key: 'e', value: 'f' },
          { key: 'g', value: 'h' },
          { key: 'i', value: 'j' },
        ],
        name: 'meta',
      },
    ];

    const { wrapper } = setup({ metatags });

    expect(wrapper.html()).toEqual(
      `<meta a="b" c="d"><meta e="f" g="h" i="j">`,
    );
  });
});
