# Cookies In Tachyon Apps

Tachyon applications need to support Chrome 51 - 66. Versions of Chrome 51 - 66
will silently drop cookies that set SameSite to unknown values. This impacts us
because we set SameSite=None.

See https://www.chromium.org/updates/same-site/incompatible-clients for more
information.

There are two ways to address this:

1. Use useragent detection to avoid setting SameSite to none for unsupported
   browsers
1. Always set two cookies: cookie A and cookie A<postfix>. Cookie A<postfix>
   never sets SameSite. Reads will first check for A and then check for
   A<posfix> if A is not found.

We chose option 2 so that we can use one pattern to support setting cookies at
the CDN, without needing to keep useragent regexes in sync.

As a convention, we use underscores as a spacing token for cookie names, so our
compatability cookie is `<name>_samesite_compat`.
